VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CStdIO"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'Declare the Win API functions
Private Declare Function GetStdHandle Lib "kernel32" _
                        (ByVal nStdHandle As Long) As Long
                        
Private Declare Function ReadFile Lib "kernel32" _
                        (ByVal hFile As Long, _
                         ByVal lpBuffer As String, _
                         ByVal nNumberOfBytesToRead As Long, _
                         lpNumberOfBytesRead As Long, _
                         ByVal lpOverlapped As Any) As Long
                         
Private Declare Function WriteFile Lib "kernel32" _
                        (ByVal hFile As Long, _
                         ByVal lpBuffer As String, _
                         ByVal nNumberOfBytesToWrite As Long, _
                         lpNumberOfBytesWritten As Long, _
                         ByVal lpOverlapped As Any) As Long
                         
Private Declare Function CloseHandle Lib "kernel32" _
                        (ByVal hObject As Long) As Long

'System Standard Handle Constants. Passed into GetStdHandle() API.
Private Const STD_OUTPUT_HANDLE As Long = -11
Private Const STD_INPUT_HANDLE As Long = -10

'Constant overlapped argument value.  Passed into ReadFile() and WriteFile() API functions.
Private Const SIO_OVERLAPPED As Long = 0

'CStdIO Errors.
Public Enum StdIOErrors
    sioSTDIN_HANDLE = 9000  'Failed to allocate standard input handle
    sioSTDOUT_HANDLE        'Failed to allocate standard output handle
    sioREAD_FAILURE             'Failed to read standard input.
    sioWRITE_FAILURE            'Failed to write to standard output.
End Enum

'Standard in and out handles
Private m_hStdOut As Long
Private m_hStdIn As Long

Private Sub Class_Initialize()
    
    'Get the standard input handle.  Raise an error if unsuccessful.
    m_hStdIn = GetStdHandle(STD_INPUT_HANDLE)
    If (m_hStdIn = 0) Then
        Err.Raise sioSTDIN_HANDLE Or vbObjectError, "CStdIO.Inititialize()", _
                    "Failed to allocate standard input handle"
    End If
    
    'Get the standard output handle.  Raise an error if unsuccessful.
    m_hStdOut = GetStdHandle(STD_OUTPUT_HANDLE)
    If (m_hStdOut = 0) Then
        Err.Raise sioSTDOUT_HANDLE Or vbObjectError, "CStdIO.Inititialize()", _
                    "Failed to allocate standard output handle"
    End If
    
    Debug.Print "StdIO class initialized: StdIn = " & m_hStdIn & _
                " StdOut = " & m_hStdOut
    
End Sub

Private Sub Class_Terminate()
    'Close the handles.
    CloseHandle m_hStdIn
    CloseHandle m_hStdOut
    Debug.Print "CStdIO class terminating"
End Sub

Public Function WriteOut(ByVal sBuf As String) As Long
    Dim lByteCnt As Long
    Dim bResult As Boolean
   
    Debug.Print "To Standard Out: " & sBuf
    
    bResult = WriteFile(m_hStdOut, sBuf, Len(sBuf), lByteCnt, SIO_OVERLAPPED)
    WriteOut = lByteCnt
    If Not bResult Then
        Err.Raise sioWRITE_FAILURE Or vbObjectError, "CStdIO.WriteOut()", _
                    "Failed to write to standard output."
    End If
End Function

Public Function ReadIn() As String
    Dim sBuf As String
    Dim lByteCnt As Long
    Dim bResult As Boolean
    
    'Prepare a 10K string
    sBuf = String$(10000, 0)
    
    bResult = ReadFile(m_hStdIn, sBuf, Len(sBuf) - 1, lByteCnt, SIO_OVERLAPPED)
    If bResult Then
        sBuf = Left$(sBuf, lByteCnt)
        ReadIn = sBuf
    Else
        ReadIn = ""
        Err.Raise sioREAD_FAILURE Or vbObjectError, "CStdIO.ReadIn()", _
                    "Failed to read standard input."
    End If
End Function

